import pandas as pd  
from sklearn.cluster import KMeans 
import pickle 
from decision_company import read_csv_file, create_kmeans, fit_predict_kmeans, col_assign_val
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Perform K-means clustering with 4 clusters  
kmeans = create_kmeans(n_clusters=4, random_state=42)  
cluster_labels = fit_predict_kmeans(kmeans, data_for_clustering_scaled)  

# Add the cluster labels to the original dataset  
col_assign_val(credit_customers, 'cluster', cluster_labels)  

print("credit_customers:\n", credit_customers)    
pickle.dump(credit_customers,open("./ref_result/credit_customers.pkl","wb"))